

<?php $__env->startSection('content'); ?>

<div class="card">
    <div class="d-sm-flex align-items-center py-3 justify-content-between">
    <h5 class=" mb-0 text-gray-800 pl-3"><?php echo e(__('Referral Comission')); ?></h5>
    <ol class="breadcrumb m-0 py-0">
        <li class="breadcrumb-item"><a href="<?php echo e(route('admin.dashboard')); ?>"><?php echo e(__('Dashboard')); ?></a></li>
        <li class="breadcrumb-item"><a href="javascript:;"><?php echo e(__('Homepage Manage')); ?></a></li>
    </ol>
    </div>
</div>

  <div class="card mb-4 mt-3">
    <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
      <h6 class="m-0 font-weight-bold text-primary"><?php echo e(__('Referral Comission')); ?></h6>
    </div>

    <div class="card-body">
      <div class="gocover" style="background: url(<?php echo e(asset('assets/images/'.$gs->admin_loader)); ?>) no-repeat scroll center center rgba(45, 45, 45, 0.5);"></div>
      <form class="geniusform" action="<?php echo e(route('admin.ps.update')); ?>" method="POST" enctype="multipart/form-data">

          <?php echo $__env->make('includes.admin.form-both', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

          <?php echo e(csrf_field()); ?>


          <div class="form-group">
            <label for="inp-title"><?php echo e(__('Referral Title')); ?></label>
            <input type="text" class="form-control" id="inp-title" name="referral_title"  placeholder="<?php echo e(__('Enter Referral Title')); ?>" value="<?php echo e($data->referral_title); ?>" required>
          </div>

          <div class="form-group">
            <label for="error_text"><?php echo e(__('Referral Text')); ?> </label>
            <textarea class="form-control summernote"  id="referral_text" name="referral_text" required rows="3" placeholder="<?php echo e(__('Enter Referral Text')); ?>"><?php echo e($data->referral_text); ?></textarea>
          </div>

          <div class="form-group">
            <label><?php echo e(__('Set Background Image')); ?></label>
            <div class="wrapper-image-preview">
                <div class="box full-width">
                    <div class="back-preview-image" style="background-image: url(<?php echo e($data->referral_banner ? asset('assets/images/'.$data->referral_banner) : asset('assets/images/placeholder.jpg')); ?>);"></div>
                    <div class="upload-options">
                        <label class="img-upload-label full-width" for="img-upload"> <i class="fas fa-camera"></i> <?php echo e(__('Upload Picture')); ?> </label>
                        <input id="img-upload" type="file" class="image-upload" name="referral_banner" accept="image/*">
                    </div>
                </div>
            </div>
          </div>

          <div class="featured-keyword-area p-4">
            <div class="lang-tag-top-filds" id="lang-section">
                <?php if($data->referral_percentage): ?>
                    <?php $__currentLoopData = json_decode($data->referral_percentage,true); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="lang-area mb-3">
                            <span class="remove lang-remove"><i class="fas fa-times"></i></span>
                            <div class="row">
                                <div class="col-md-12">
                                    <label for="inp-title"><?php echo app('translator')->get('Level '); ?># <?php echo e($key + 1); ?></label>
                                    <input type="text" class="form-control" name="referral_percentage[]" placeholder="<?php echo e(__('Enter Referral Percentage')); ?>" value="<?php echo e($data); ?>" required>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php endif; ?>

            </div>

            <a href="javascript:;" id="lang-btn" class="add-fild-btn d-flex justify-content-center"><i class="icofont-plus"></i> <?php echo e(__('Add Attribute')); ?></a>
          </div>

          <input type="hidden" name="coutPercentage" value="<?php echo e($referralCount); ?>" id="countPercentage">
          <button type="submit" id="submit-btn" class="btn btn-primary mt-2 w-100"><?php echo e(__('Submit')); ?></button>

      </form>
    </div>
  </div>


<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
<script type="text/javascript">
    "use strict";
    function isEmpty(el){
        return !$.trim(el.html())
    }
    var level = $("#countPercentage").val();

   $("#lang-btn").on('click', function(){
  
      $("#lang-section").append(''+
                                  '<div class="lang-area mb-3">'+
                                    '<span class="remove lang-remove"><i class="fas fa-times"></i></span>'+
                                    '<div class="row">'+
                                      '<div class="col-md-12">'+
                                       '<label for="inp-title">Level #'+level+'</label>'+
                                      '<input type="text" class="form-control" name="referral_percentage[]" placeholder="<?php echo e(__('Enter Referral Percentage')); ?>" value="" required>'+
                                      '</div>'+
                                    '</div>'+
                                  '</div>'+
                              '');
                              level ++;
  });
  
  $(document).on('click','.lang-remove', function(){
      $(this.parentNode).remove();
  
  });
  
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\mamp\htdocs\geniushyip\project\resources\views/admin/pagesetting/referral_section.blade.php ENDPATH**/ ?>