

<?php $__env->startPush('css'); ?>
    
<?php $__env->stopPush(); ?>

<?php $__env->startSection('contents'); ?>
<div class="breadcrumb-area">
    <h3 class="title"><?php echo app('translator')->get('Commissions Log'); ?></h3>
    <ul class="breadcrumb">
        <li>
            <a href="<?php echo e(route('user.dashboard')); ?>"><?php echo app('translator')->get('Dashboard'); ?></a>
        </li>
        <li>
            <?php echo app('translator')->get('Commissions Log'); ?>
        </li>
    </ul>
</div>

<div class="dashboard--content-item">
    <div class="table-responsive table--mobile-lg">
        <table class="table bg--body">
            <thead>
                <tr>
                    <th><?php echo e(__('Date')); ?></th>
                    <th><?php echo e(__('Type')); ?></th>
                    <th><?php echo e(__('From')); ?></th>
                    <th><?php echo e(__('Amount')); ?></th>
                </tr>
            </thead>
            <tbody>
              <?php if(count($commissions) == 0): ?>
                <tr>
                  <td colspan="12">
                    <h4 class="text-center m-0 py-2"><?php echo e(__('No Data Found')); ?></h4>
                  </td>
                </tr>
                <?php else: ?>
                  <?php $__currentLoopData = $commissions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>  
                    <?php
                        $receiver = App\Models\User::whereId($data->from_user_id)->first();
                    ?>
                  <tr>
                      <td data-label="<?php echo e(__('Date')); ?>">
                          <div>
                              <?php echo e($data->created_at->toDateString()); ?>

                          </div>
                      </td>

                      <td data-label="<?php echo e(__('Type')); ?>">
                          <div>
                              <?php echo e(ucfirst($data->type)); ?>

                          </div>
                      </td>

                      <td data-label="<?php echo e(__('From')); ?>">
                          <div>
                              <?php echo e($receiver != NULL ? $receiver->name : ''); ?>

                          </div>
                      </td>

                      <td data-label="<?php echo e(__('Amount')); ?>">
                          <div>
                              <?php echo e(showprice($data->amount)); ?>

                          </div>
                      </td>
                  </tr>
                  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
    <?php echo e($commissions->render()); ?>

</div>


<?php $__env->stopSection(); ?>

<?php $__env->startPush('js'); ?>

<?php $__env->stopPush(); ?>


<?php echo $__env->make('layouts.user', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\mamp\htdocs\geniushyip\project\resources\views/user/referral/commission.blade.php ENDPATH**/ ?>