<?php $__env->startPush('css'); ?>
    
<?php $__env->stopPush(); ?>

<?php $__env->startSection('contents'); ?>
<div class="breadcrumb-area">
  <h3 class="title"><?php echo app('translator')->get('Withdraw'); ?></h3>
  <ul class="breadcrumb">
      <li>
          <a href="<?php echo e(route('user.dashboard')); ?>"><?php echo app('translator')->get('Dashboard'); ?></a>
      </li>
      <li>
          <?php echo app('translator')->get('Withdraw'); ?>
      </li>
  </ul>
</div>

<div class="dashboard--content-item">
  <div class="row g-3">
    <?php $__currentLoopData = $methods; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?> 
      <div class="col-sm-6 col-lg-4 col-xxl-3">
          <div class="card default--card">
              <div class="card-header text-center bg--section py-2 border-bottom">
                  <h5 class="card-title m-0"><?php echo e(ucfirst($data->name)); ?></h5>
              </div>
              <div class="card-body">
                  <img src="<?php echo e(asset('assets/images/'.$data->photo)); ?>" class="card-img" alt="payment">
                  <ul class="list-group list-group-flush withdraw--list pt-3">
                      <li class="list-group-item">
                        <strong class="name"><?php echo app('translator')->get('Withdraw Amount'); ?> </strong>
                        <span class="info text--success"><?php echo e($data->min_amount); ?> <?php echo e($data->currency->name); ?> - <?php echo e($data->max_amount); ?> <?php echo e($data->currency->name); ?></span>
                      </li>

                      <li class="list-group-item">
                        <strong class="name"><?php echo app('translator')->get('Total Fixed Charge'); ?> </strong>
                        <span class="info text--danger"><?php echo e($data->fixed); ?> <?php echo e($data->currency->name); ?></span>
                      </li>

                      <li class="list-group-item">
                        <strong class="name"><?php echo app('translator')->get('Total Percentage Charge'); ?> </strong>
                        <span class="info text--danger"><?php echo e($data->percentage); ?> %</span>
                      </li>
                  </ul>
              </div>
              <div class="card-footer bg--section border-top d-flex">
                  <a href="#0" id="withdrawNow" class="cmn--btn w-100" data-bs-toggle="modal"
                      data-bs-target="#withdraw-modal" data-id="<?php echo e($data->id); ?>" data-name="<?php echo e($data->name); ?>" data-currName="<?php echo e($data->currency->name); ?>" data-currSign="<?php echo e($data->currency->sign); ?>"><?php echo app('translator')->get('Withdraw Now'); ?></a>
              </div>
          </div>
      </div>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
  </div>
</div>

<div class="dashboard--content-item">
    <div class="table-responsive table--mobile-lg">
        <table class="table bg--body">
            <thead>
                <tr>
                    <th><?php echo app('translator')->get('Buyer'); ?></th>
                    <th><?php echo app('translator')->get('Payment Method'); ?></th>
                    <th><?php echo app('translator')->get('Amount'); ?></th>
                    <th><?php echo app('translator')->get('Fee'); ?></th>
                    <th><?php echo app('translator')->get('Status'); ?></th>
                    <th><?php echo app('translator')->get('Options'); ?></th>
                </tr>
            </thead>
            <tbody>
              <?php if(count($withdraws) == 0): ?>
                <tr>
                  <td colspan="12">
                    <h4 class="text-center m-0 py-2"><?php echo e(__('No Data Found')); ?></h4>
                  </td>
                </tr>
                <?php else: ?>
                  <?php $__currentLoopData = $withdraws; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>  
                    <tr>
                        <td data-label="Buyer">
                            <div class="cmn--media">
                                <img src="<?php echo e(auth()->user()->photo ? asset('assets/images/'.auth()->user()->photo) : asset('assets/front/images/clients/client1.jpg')); ?>" alt="clients">
                                <h6 class="m-0 subtitle"><?php echo e(auth()->user()->name); ?></h6>
                            </div>
                        </td>
                        <td data-label="Payment Method">
                            <div>
                                <?php echo e(ucfirst($data->method)); ?>

                            </div>
                        </td>

                        <td data-label="Amount">
                            <div>
                                <?php echo e(convertedPrice($data->amount,$data->currency_id)); ?>

                            </div>
                        </td>

                        <td data-label="Fee">
                            <div>
                                <?php echo e(convertedPrice($data->fee,$data->currency_id)); ?>

                            </div>
                        </td>

                        <td data-label="Status">
                            <div>
                              <?php if($data->status == 'pending'): ?>
                                <span class="badge btn--warning btn-sm"><?php echo app('translator')->get('Pending'); ?></span>
                              <?php elseif($data->status == 'completed'): ?>
                                <span class="badge btn--success btn-sm"><?php echo app('translator')->get('Completed'); ?></span>
                              <?php else: ?>
                                <span class="badge btn--danger btn-sm"><?php echo app('translator')->get('Rejected'); ?></span>
                              <?php endif; ?>
                            </div>
                        </td>

                        <td data-label="Options">
                          <div class="text-center">
                              <a href="<?php echo e(route('user.withdraw.details',$data->id)); ?>" class="btn btn--base text--dark btn-sm">
                                  <i class="fas fa-info-circle"></i>
                                  <?php echo app('translator')->get('details'); ?>
                              </a>
                          </div>
                      </td>
                    </tr>
                  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
</div>


<div class="modal fade" id="withdraw-modal" aria-modal="true" role="dialog">
  <div class="modal-dialog">
      <div class="modal-content">
        <form action="<?php echo e(route('user.withdraw.request')); ?>" method="POST" enctype="multipart/form-data">
          <?php echo csrf_field(); ?>
          <div class="modal-body p-4">
              <h4 class="modal-title text-center" id="withdrawModalTitle"><?php echo app('translator')->get('Stripe Withdraw'); ?></h4>
              <div class="pt-3 pb-4">
                <label for="amount" class="form-label"><?php echo app('translator')->get('Enter Amount'); ?></label>
                <div class="input-group input--group">
                    <input type="number" name="amount" class="form-group-input form-control form--control bg--section"
                        placeholder="0.00" id="amount" >
                    <button type="button" class="input-group-text" id="withdrawModalCurrency">USD</button>
                </div>

                <label for="withdraw_wallet" class="form-label"><?php echo app('translator')->get('Select Wallet'); ?></label>
                <div class="input-group input--group">
                    <select name="withdraw_wallet" id="withdraw_wallet" class="form-control" required>
                        <option value="main_wallet"><?php echo e(__('Main Balance')); ?></option>
                        <option value="interest_wallet"><?php echo e(__('Interest Balance')); ?></option>
                    </select>
                </div>

                <label for="info" class="form-label mt-2"><?php echo app('translator')->get('Enter Account Information'); ?></label>
                <div class="input-group input--group">
                    <textarea name="details" class="form-group-input form-control form--control bg--section" cols="30" rows="10"></textarea>
                </div>
                <input type="hidden" name="method_id" value="" id="withdrawMethodId">
              </div>
              <div class="d-flex">
                  <button type="button" class="btn shadow-none btn--danger me-2 w-50" data-bs-dismiss="modal"><?php echo app('translator')->get('Close'); ?></button>
                  <button type="submit" class="btn shadow-none btn--success w-50"><?php echo app('translator')->get('Proceed'); ?></button>
              </div>
          </div>
        </form>
      </div>
  </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('js'); ?>
  <script>
    'use strict';
    $(document).on('click','#withdrawNow',function(){
      $("#withdrawModalTitle").text($(this).attr('data-name')+' Withdraw');
      $("#withdrawModalCurrency").text($(this).attr('data-currName'));
      $("#withdrawMethodId").val($(this).attr('data-id'));
    });
  </script>
<?php $__env->stopPush(); ?>


<?php echo $__env->make('layouts.user', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\mamp\htdocs\geniushyip\project\resources\views/user/withdraw/index.blade.php ENDPATH**/ ?>