

<?php $__env->startPush('css'); ?>
    
<?php $__env->stopPush(); ?>

<?php $__env->startSection('contents'); ?>

<div class="breadcrumb-area">
  <h3 class="title"><?php echo app('translator')->get('Dashboard'); ?></h3>
  <ul class="breadcrumb">
      <li>
          <a href="<?php echo e(route('user.dashboard')); ?>"><?php echo app('translator')->get('Dashboard'); ?></a>
      </li>
      <li>
          <?php echo app('translator')->get('Dashboard'); ?>
      </li>
  </ul>
</div>
<div class="dashboard--content-item">
    <?php if(auth()->user()->kyc_info == NULL && auth()->user()->kyc_status == 0): ?>  
    <div class="row mb-3">
      <div class="col-md-12">
          <div class="card default--card">
              <div class="card-body">
                    <div class="form-group w-100 d-flex flex-wrap align-items-center justify-content-evenly justify-content-sm-between">
                      <h3 class="my-1 text-center text-sm-start"><?php echo e(__('You have a information to submit for kyc verification.')); ?></h3>
                      <div class="my-1">
                        <a href="<?php echo e(route('user.kyc.form')); ?>" class="btn btn-warning"><?php echo app('translator')->get('Submit'); ?></a>
                      </div>
                  </div>
              </div>
          </div>
      </div>
    </div>
    <?php elseif(auth()->user()->kyc_status == 2): ?>
    <div class="row mb-3">
        <div class="col-md-12">
            <div class="card default--card">
                <div class="card-body">
                      <div class="form-group w-100 d-flex flex-wrap align-items-center justify-content-evenly justify-content-sm-between">
                      <h3 class="my-1 text-center text-sm-start"><?php echo e(__('Your submitted kyc informations rejected.')); ?></h3>
                    </div>
                </div>
            </div>
        </div>
      </div>
    <?php elseif(auth()->user()->kyc_status != 1): ?>
    <div class="row mb-3">
        <div class="col-md-12">
            <div class="card default--card">
                <div class="card-body">
                      <div class="form-group w-100 d-flex flex-wrap align-items-center justify-content-evenly justify-content-sm-between">
                      <h3 class="my-1 text-center text-sm-start"><?php echo e(__('Your submitted informations under reviewing.')); ?></h3>
                    </div>
                </div>
            </div>
        </div>
      </div>
    <?php else: ?> 
      <div></div>
    <?php endif; ?>
  <div class="dashboard--wrapper">
        <div class="dashboard--width">
          <div class="dashboard-card h-100">
              
              <div class="dashboard-card__header">
                  <div class="dashboard-card__header__icon">
                      <img src="<?php echo e(asset('assets/images/gross.png')); ?>" alt="wallet">
                  </div>
                  <div class="dashboard-card__header__cont">
                      <h6 class="name"><?php echo app('translator')->get('Main Balance'); ?></h6>
                      <div class="balance"><?php echo e(showprice(auth()->user()->balance)); ?></div>
                  </div>
              </div>
          </div>
       </div>

        <div class="dashboard--width">
            <div class="dashboard-card h-100">
                
                <div class="dashboard-card__header">
                    <div class="dashboard-card__header__icon">
                        <img src="<?php echo e(asset('assets/images/money.png')); ?>" alt="wallet">
                    </div>
                    <div class="dashboard-card__header__cont">
                        <h6 class="name"><?php echo app('translator')->get('Interest Balance'); ?></h6>
                        <div class="balance"><?php echo e(showprice(auth()->user()->interest_balance)); ?></div>
                    </div>
                </div>
            </div>
        </div>

        <div class="dashboard--width">
            <div class="dashboard-card h-100">
                
                <div class="dashboard-card__header">
                    <div class="dashboard-card__header__icon">
                        <img src="<?php echo e(asset('assets/images/deposit.png')); ?>" alt="wallet">
                    </div>
                    <div class="dashboard-card__header__cont">
                        <h6 class="name"><?php echo app('translator')->get('Total Deposit'); ?></h6>
                        <div class="balance"><?php echo e(showprice($total_deposits)); ?></div>
                    </div>
                </div>
            </div>
        </div>

        <div class="dashboard--width">
            <div class="dashboard-card h-100">
                
                <div class="dashboard-card__header">
                    <div class="dashboard-card__header__icon">
                        <img src="<?php echo e(asset('assets/images/investing.png')); ?>" alt="wallet">
                    </div>
                    <div class="dashboard-card__header__cont">
                        <h6 class="name"><?php echo app('translator')->get('Total Invest'); ?></h6>
                        <div class="balance"><?php echo e(showprice($total_invests)); ?></div>
                    </div>
                </div>
            </div>
        </div>

        <div class="dashboard--width">
            <div class="dashboard-card h-100">
                
                <div class="dashboard-card__header">
                    <div class="dashboard-card__header__icon">
                        <img src="<?php echo e(asset('assets/images/cash-withdrawal.png')); ?>" alt="wallet">
                    </div>
                    <div class="dashboard-card__header__cont">
                        <h6 class="name"><?php echo app('translator')->get('Total Payout'); ?></h6>
                        <div class="balance"><?php echo e(showprice($total_payouts)); ?></div>
                    </div>
                </div>
            </div>
        </div>

        <div class="dashboard--width">
            <div class="dashboard-card h-100">
                
                <div class="dashboard-card__header">
                    <div class="dashboard-card__header__icon">
                        <img src="<?php echo e(asset('assets/images/teamwork.png')); ?>" alt="wallet">
                    </div>
                    <div class="dashboard-card__header__cont">
                        <h6 class="name"><?php echo app('translator')->get('Total Refferal Bonus'); ?></h6>
                        <div class="balance"><?php echo e(showprice($total_referral_bonus)); ?></div>
                    </div>
                </div>
            </div>
        </div>

        <div class="dashboard--width">
            <div class="dashboard-card h-100">
                
                <div class="dashboard-card__header">
                    <div class="dashboard-card__header__icon">
                        <img src="<?php echo e(asset('assets/images/transaction.png')); ?>" alt="wallet">
                    </div>
                    <div class="dashboard-card__header__cont">
                        <h6 class="name"><?php echo app('translator')->get('Total Transaction'); ?></h6>
                        <div class="balance"><?php echo e(showprice($total_transactions)); ?></div>
                    </div>
                </div>
            </div>
        </div>

        <div class="dashboard--width">
            <div class="dashboard-card h-100">
                
                <div class="dashboard-card__header">
                    <div class="dashboard-card__header__icon">
                        <img src="<?php echo e(asset('assets/images/tickets.png')); ?>" alt="wallet">
                    </div>
                    <div class="dashboard-card__header__cont">
                        <h6 class="name"><?php echo app('translator')->get('Total Ticket'); ?></h6>
                        <div class="balance"><?php echo e($total_tickets); ?></div>
                    </div>
                </div>
            </div>
        </div>
  </div>
</div>

<div class="dashboard--content-item">
  <div class="row gy-4">
      <div class="col-md-12">
          <div class="dashboard--content-item">
              <h5 class="dashboard-title"><?php echo app('translator')->get('Referral URL'); ?></h5>
              <div class="dashboard-refer">
                  <div class="input-group input--group">
                      <input type="text" class="form-control form--control" readonly
                          value="<?php echo e(url('/').'?reff='.$user->affilate_code); ?>" id="cronjobURL">
                      <button class="input-group-text px-3 btn--primary border-0" type="button" id="copyBoard" onclick="myFunction()">
                          <i class="far fa-copy"></i>
                      </button>
                  </div>
              </div>
          </div>
      </div>
  </div>
</div>

<div class="dashboard--content-item">
	  <div class="table-responsive table--mobile-lg">
		  <table class="table bg--body">
			  <thead>
				  <tr>
					<th><?php echo app('translator')->get('No'); ?></th>
					<th><?php echo app('translator')->get('Type'); ?></th>
					<th><?php echo app('translator')->get('Txnid'); ?></th>
					<th><?php echo app('translator')->get('Amount'); ?></th>
					<th><?php echo app('translator')->get('Date'); ?></th>
				  </tr>
			  </thead>
			  <tbody>
                <?php if(count($transactions) == 0): ?>
                    <tr>
                    <td colspan="12">
                        <h4 class="text-center m-0 py-2"><?php echo e(__('No Data Found')); ?></h4>
                    </td>
                    </tr>
                <?php else: ?>
				<?php $__currentLoopData = $transactions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
				  <?php
					  $from = App\Models\User::where('id',$data->user_id)->first();
				  ?>
					<tr>
						<td data-label="<?php echo app('translator')->get('No'); ?>">
							<div>

							<span class="text-muted"><?php echo e($loop->iteration); ?></span>
							</div>
						</td>

						<td data-label="<?php echo app('translator')->get('Type'); ?>">
							<div>
							<?php echo e(strtoupper($data->type)); ?>

							</div>
						</td>

						<td data-label="<?php echo app('translator')->get('Txnid'); ?>">
							<div>
							<?php echo e($data->txnid); ?>

							</div>
						</td>

						<td data-label="<?php echo app('translator')->get('Amount'); ?>">
							<div>
							<p class="text-<?php echo e($data->profit == 'plus' ? 'success' : 'danger'); ?>"><?php echo e(showprice($data->amount,$currency)); ?></p>
							</div>
						</td>

						<td data-label="<?php echo app('translator')->get('Date'); ?>">
							<div>
							<?php echo e(date('d M Y',strtotime($data->created_at))); ?>

							</div>
						</td>
					</tr>
			  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
	        <?php endif; ?>

			  </tbody>
		  </table>
	  </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('js'); ?>
    <script>
      'use strict';

      function myFunction() {
        var copyText = document.getElementById("cronjobURL");
        copyText.select();
        copyText.setSelectionRange(0, 99999);
        document.execCommand("copy");
        $.notify("Referral url copied", "info");
    }
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.user', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\mamp\htdocs\geniushyip\project\resources\views/user/dashboard.blade.php ENDPATH**/ ?>