

<?php $__env->startPush('css'); ?>
    
<?php $__env->stopPush(); ?>

<?php $__env->startSection('contents'); ?>
<div class="breadcrumb-area">
    <h3 class="title"><?php echo app('translator')->get('Investment plans'); ?></h3>
    <ul class="breadcrumb">
        <li>
            <a href="<?php echo e(route('user.invest.history')); ?>"><?php echo app('translator')->get('History'); ?></a>
        </li>
        <li>
            <?php echo app('translator')->get('Investment plans'); ?>
        </li>
    </ul>
</div>
<div class="dashboard--content-item">
    <div class="pricing--wrapper row g-3 g-md-4 g-lg-3 g-xxl-4">
        <?php if(count($plans) == 0): ?>
            <div class="col-12 text-center">
                    <h3 class="m-0"><?php echo e(__('No Plan Found')); ?></h3>
            </div>
        <?php else: ?>
            <?php $__currentLoopData = $plans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <?php
                $schedule = \App\Models\ManageSchedule::where('time',$data->schedule_hour)->first();
            ?>
            <div class="col-lg-3 col-sm-6 col-md-6">
                <div class="plan__item">
                    <div class="plan__item-header">
                        <div class="left">
                            <h5 class="title"><?php echo e($data->title); ?></h5>
                            <span><?php echo e($data->subtitle); ?></span>
                        </div>
                        <div class="right">
                            <h5 class="title"><?php echo e($data->profit_percentage); ?>%</h5>
                            <span><?php echo app('translator')->get('Return'); ?></span>
                        </div>
                    </div>
                    <div class="plan__item-body">
                        <ul>
                            <li>
                                <span class="name"><?php echo app('translator')->get('Profit'); ?></span>
                                <span class="info">
                                    <?php echo e($data->lifetime_return == 1 ? 'Lifetime' :  'Every '.$schedule->name); ?>

                                </span>
                            </li>
                            <li>
                                <span class="name me-1"><?php echo app('translator')->get('Capital will back'); ?></span>
                                <span class="badge align-self-center me-auto bg--<?php echo e($data->captial_return == 1 ? 'primary' : 'danger'); ?>"><?php echo e($data->captial_return == 1 ? 'Yes' : 'No'); ?></span>
                            </li>
                        </ul>
                        <?php if($data->invest_type == 'range'): ?>
                            <h6 class="text-center amount-range"><?php echo e(showPrice($data->min_amount)); ?> - <?php echo e(showPrice($data->max_amount)); ?></h6>
                        <?php else: ?> 
                            <h6 class="text-center amount-range"><?php echo e(showPrice($data->fixed_amount)); ?></h6>
                        <?php endif; ?>
                        <button class="cmn--btn w-100 invest-plan" type="button" data-bs-toggle="modal"
                            data-bs-target="#invest-modal" data-title="<?php echo e($data->title); ?>" data-id="<?php echo e($data->id); ?>" data-type="<?php echo e($data->invest_type == 'range' ? 0 : 1); ?>" data-fixAmount="<?php echo e(rootPrice($data->fixed_amount)); ?>">
                            <?php echo app('translator')->get('Invest Now'); ?>
                        </button>
                    </div>
                </div>
            </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        <?php endif; ?>
    </div>
</div>

    <!-- Invest Modal -->
    <div class="modal fade" id="invest-modal">
        <div class="modal-dialog">
            <div class="modal-content">
                <form class="investForm" action="<?php echo e(route('user.invest.amount')); ?>" method="POST">
                    <?php echo csrf_field(); ?>
                    <div class="modal-body p-4">
                        <h4 class="modal-title text-center plan-title"><?php echo app('translator')->get('Basic Plan'); ?></h4>
                        <div class="pt-3 pb-4">
                            <label for="amount" class="form-label"><?php echo app('translator')->get('Enter Amount'); ?></label>
                            <div class="input-group input--group">
                                <input type="number" name="amount" class="form-group-input form-control form--control bg--section"
                                    placeholder="0.00" id="modalAmount">
                                <button type="button" class="input-group-text"><?php echo app('translator')->get('USD'); ?></button>
                            </div>

                            <label for="amount" class="form-label"><?php echo app('translator')->get('Select Wallet'); ?></label>
                            <div class="input-group input--group">
                                <select name="wallet" id="investMethod" class="form-control" required>
                                    <option value="checkout"><?php echo e(__('checkout')); ?></option>
                                    <option value="main_wallet"><?php echo e(__('Main Balance')); ?></option>
                                    <option value="interest_wallet"><?php echo e(__('Interest Balance')); ?></option>
                                </select>
                            </div>
                        </div>
                        <input type="hidden" name="investId" id="investId" value="">
                        <div class="d-flex">
                            <button type="button" class="btn shadow-none btn--danger me-2 w-50"
                                data-bs-dismiss="modal"><?php echo app('translator')->get('Close'); ?></button>
                            <button type="submit" class="btn shadow-none btn--success w-50"><?php echo app('translator')->get('Proceed'); ?></button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <!-- Invest Modal -->
<?php $__env->stopSection(); ?>

<?php $__env->startPush('js'); ?>
<script>
    'use strict';

    $('.invest-plan').on('click',function(){
        $('#modalAmount').val('');
        $('#modalAmount').prop('readonly',false)

        let id = $(this).data('id');
        let title = $(this).data('title');
        let type = $(this).data('type');

        if(type == 1){
            $('#modalAmount').val($(this).attr('data-fixAmount'));
            $('#modalAmount').prop('readonly',true)
        }
        $('#investId').val(id);
        $('.plan-title').text(title);
    });

    $(document).on('change','#investMethod',function(){
        var val = $(this).val();
 
        if(val == 'checkout'){
            $('.investForm').prop('action','<?php echo e(route('user.invest.amount')); ?>');
        }

        if(val == 'main_wallet'){
            $('.investForm').prop('action','<?php echo e(route('user.invest.mainWallet')); ?>');
        }

        if(val == 'interest_wallet'){
            $('.investForm').prop('action','<?php echo e(route('user.invest.interestWallet')); ?>');
        }
    });

</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.user', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\mamp\htdocs\geniushyip\project\resources\views/user/invest/plans.blade.php ENDPATH**/ ?>