

<?php $__env->startSection('content'); ?>

<div class="card">
	<div class="d-sm-flex align-items-center justify-content-between">
    <h5 class=" mb-0 text-gray-800 pl-3"><?php echo e(__('Edit Plan')); ?> <a class="btn btn-primary btn-rounded btn-sm" href="<?php echo e(route('admin.plans.index')); ?>"><i class="fas fa-arrow-left"></i> <?php echo e(__('Back')); ?></a></h5>
    <ol class="breadcrumb">
      <li class="breadcrumb-item"><a href="<?php echo e(route('admin.dashboard')); ?>"><?php echo e(__('Dashboard')); ?></a></li>
      <li class="breadcrumb-item"><a href="javascript:;"><?php echo e(__('Manage Plan')); ?></a></li>
    </ol>
	</div>
</div>

<div class="row justify-content-center mt-3">
  <div class="col-md-10">
    <div class="card mb-4">
      <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
        <h6 class="m-0 font-weight-bold text-primary"><?php echo e(__('Edit Plan Form')); ?></h6>
      </div>

      <div class="card-body py-5">
        <div class="gocover" style="background: url(<?php echo e(asset('assets/images/'.$gs->admin_loader)); ?>) no-repeat scroll center center rgba(45, 45, 45, 0.5);"></div>
        <form class="geniusform" action="<?php echo e(route('admin.plans.update',$data->id)); ?>" method="POST" enctype="multipart/form-data">

            <?php echo $__env->make('includes.admin.form-both', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

            <?php echo e(csrf_field()); ?>


            <div class="form-group">
              <label for="inp-title"><?php echo e(__('Title')); ?></label>
              <input type="text" class="form-control" id="inp-title" name="title"  placeholder="<?php echo e(__('Enter Title')); ?>" value="<?php echo e($data->title); ?>" required>
            </div>

            <div class="form-group">
              <label for="inp-subtitle"><?php echo e(__('Subtitle')); ?></label>
              <input type="text" class="form-control" id="inp-subtitle" name="subtitle"  placeholder="<?php echo e(__('Enter Subtitle')); ?>" value="<?php echo e($data->subtitle); ?>" required>
            </div>

            <div class="form-group">
                <label for="invest_type"><?php echo e(__('Invest Type')); ?></label>
                <select name="invest_type" class="form-control" id="invest_type">
                  <option value="fixed" <?php echo e($data->invest_type == 'fixed' ? 'selected' : ''); ?>> <?php echo e(__('Fixed')); ?> </option>
                  <option value="range" <?php echo e($data->invest_type == 'range' ? 'selected' : ''); ?>> <?php echo e(__('Range')); ?> </option>
                </select>
            </div>

            <div class="form-group <?php echo e($data->fixed_amount != NULL ? '' : 'd-none'); ?>" id="fixedAmount">
              <label for="inp-fixed_amount"><?php echo e(__('Fixed Amount')); ?> (<?php echo e($currency->name); ?>)</label>
              <input type="number" class="form-control" id="inp-fixed_amount" name="fixed_amount"  placeholder="<?php echo e(__('Fixed Amount')); ?>" value="<?php echo e($data->fixed_amount); ?>">
            </div>

            <div class="row <?php echo e($data->fixed_amount == NULL ? '' : 'd-none'); ?>" id="Range">
                <div class="col-md-6">
                  <div class="form-group">
                      <label for="min_amount"><?php echo e(__('Minimum Amount')); ?> (<?php echo e($currency->name); ?>)</label>
                      <input type="number" class="form-control" id="min_amount" name="min_amount" placeholder="<?php echo e(__('Minimum Amount')); ?>" value="<?php echo e($data->min_amount); ?>">
                    </div>
                </div>

                <div class="col-md-6">
                  <div class="form-group">
                      <label for="max_amount"><?php echo e(__('Maximum Amount')); ?> (<?php echo e($currency->name); ?>)</label>
                      <input type="number" class="form-control" id="max_amount" name="max_amount" placeholder="<?php echo e(__('Maximum Amount')); ?>" value="<?php echo e($data->max_amount); ?>">
                    </div>
                </div>
            </div>

            <div class="form-group">
              <label for="inp-percentage"><?php echo e(__('Return Percentage')); ?> (%)</label>
              <input type="number" class="form-control" id="inp-percentage" name="profit_percentage"  placeholder="<?php echo e(__('Enter Return Percentage')); ?>" value="<?php echo e($data->profit_percentage); ?>" required>
            </div>

            <div class="form-group">
              <label for="schedule_hour"><?php echo e(__('Every')); ?></label>
              <select name="schedule_hour" class="form-control" id="schedule_hour">
                <?php $__currentLoopData = $schedules; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$schedule): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                  <option value="<?php echo e($schedule->time); ?>" data-sechedule-id="<?php echo e($schedule->id); ?>" <?php echo e($schedule->time == $data->schedule_hour ? 'selected' : ''); ?>> <?php echo e($schedule->name); ?> </option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
              </select>
            </div>

            <div class="form-group">
              <label for="lifetime_return"><?php echo e(__('Lifetime Return ?')); ?></label>
              <select name="lifetime_return" class="form-control" id="lifetime_return" required>
                <option value="1" <?php echo e($data->lifetime_return == 1 ? 'selected' : ''); ?>> <?php echo e(__('Yes')); ?> </option>
                <option value="0" <?php echo e($data->lifetime_return == 0 ? 'selected' : ''); ?>> <?php echo e(__('No')); ?> </option>
              </select>
            </div>

            <div class="form-group <?php echo e($data->lifetime_return == 0 ? '' : 'd-none'); ?>" id="repeatable">
              <label for="inp-name"><?php echo e(__('Repeatable')); ?></label>
              <div class="input-group mb-3">
                <input type="text" name="profit_repeat" class="form-control" placeholder="<?php echo app('translator')->get('Repeatable'); ?>" aria-label="<?php echo app('translator')->get('Repeatable'); ?>" value="<?php echo e($data->profit_repeat); ?>" aria-describedby="basic-addon2">
                <div class="input-group-append">
                  <span class="input-group-text" id="basic-addon2"><?php echo app('translator')->get('Times'); ?></span>
                </div>
              </div>
            </div>

            <div class="form-group">
              <label for="captial_return"><?php echo e(__('Capital Return ?')); ?></label>
              <select name="captial_return" class="form-control" id="captial_return">
                <option value="1" <?php echo e($data->captial_return == 1 ? 'selectd' : ''); ?>> <?php echo e(__('Yes')); ?> </option>
                <option value="0" <?php echo e($data->captial_return == 0 ? 'selectd' : ''); ?>> <?php echo e(__('No')); ?> </option> 
              </select>
            </div>

            <div class="form-group">
              <label for="status"><?php echo e(__('Status')); ?></label>
              <select name="status" class="form-control" id="status">
                <option value="1" <?php echo e($data->status == 1 ? 'selectd' : ''); ?>> <?php echo e(__('activated')); ?> </option>
                <option value="0" <?php echo e($data->status == 0 ? 'selectd' : ''); ?>> <?php echo e(__('deactivated')); ?> </option>
              </select>
            </div>
            <input type="hidden" name="manage_schedule_id" value="<?php echo e($data->manage_schedule_id); ?>" id="scheduleId">
            <button type="submit" id="submit-btn" class="btn btn-primary w-100 mt-3"><?php echo e(__('Submit')); ?></button>

        </form>
      </div>
    </div>
  </div>

</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
    <script>
        'use strict';
        $(document).on('change','#schedule_hour',function(){
          $('#scheduleId').val($(this).find(':selected').data('sechedule-id'))
        });

        $(document).on('change','#invest_type',function(){
           if($(this).val() == 'range'){
              $("#Range").removeClass('d-none');
              $("#fixedAmount").addClass('d-none');
           }else{
              $("#Range").addClass('d-none');
              $("#fixedAmount").removeClass('d-none');
           }
        });

        $(document).on('change','#lifetime_return',function(){
           if($(this).val() == 0){
              $("#repeatable").removeClass('d-none');
           }else{
              $("#repeatable").addClass('d-none');
           }
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\mamp\htdocs\geniushyip\project\resources\views/admin/plans/edit.blade.php ENDPATH**/ ?>