

<?php $__env->startPush('css'); ?>
    
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
    <!-- Banner -->
    <section class="banner-section bg--gradient overflow-hidden">
        <div class="particle"></div>
        <div class="particle2"></div>
        <div class="particle3"></div>
        <div class="particle4"></div>
        <div class="banner-bg bg_img" data-img="<?php echo e(asset('assets/images/'.$ps->hero_photo)); ?>">
            <div class="container">
                <div class="banner-wrapper">
                    <div class="banner-cont text--light">
                        <h1 class="title text--base"><?php echo e($ps->hero_title); ?></h1>
                        <p>
                            <?php echo e($ps->hero_subtitle); ?>

                        </p>
                        <div class="btn__grp">
                            <a href="<?php echo e($ps->hero_btn_url); ?>" class="cmn--btn"><?php echo app('translator')->get('Get Started'); ?> <span class="round-effect">
                                    <i class="fas fa-long-arrow-alt-right"></i>
                                </span></a>
                            <a href="<?php echo e($ps->hero_link); ?>" class="video--btn" data-lightbox>
                                <i class="fas fa-play"></i>
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- Banner -->

    <!-- About -->
    <section class="about-section overflow-hidden pt-100 pb-100 position-relative">
        <div class="container">
            <div class="row gy-4 gy-sm-5 flex-wrap-reverse align-items-center">
                <div class="col-lg-6">
                    <div class="about--img">
                        <img src="<?php echo e(asset('assets/images/'.$ps->about_photo)); ?>" alt="about">
                    </div>
                </div>
                <div class="col-lg-6">
                    <div class="about--content">
                        <div class="section-header mb-4">
                            <h6 class="section-header__subtitle"><?php echo app('translator')->get('Who We are'); ?></h6>
                            <h2 class="section-header__title"><?php echo e($ps->about_title); ?></h2>
                          
                        </div>
                        <p class="about-txt m-0 mb-4">
                            <?php
                                echo $ps->about_text;
                            ?>
                        </p>
                        <a href="<?php echo e($ps->about_link); ?>" class="cmn--btn"><?php echo app('translator')->get('Read More'); ?> 
                            <span class="round-effect">
                                <i class="fas fa-long-arrow-alt-right"></i>
                            </span>
                        </a>
                    </div>
                    <div class="border-top mt-4">
                        <div class="counter-area">
                            <?php $__currentLoopData = $counters; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>  
                                <div class="counter-item">
                                    <div class="counter-thumb">
                                        <img src="<?php echo e(asset('assets/images/'.$data->photo)); ?>" alt="about">
                                    </div>
                                    <div class="counter-content">
                                        <div class="counter-header">
                                            <h4 class="title odometer" data-odometer-final="<?php echo e($data->count); ?>">0</h4>
                                            <h4 class="title"><?php echo e($data->messurement); ?></h4>
                                        </div>
                                        <h6 class="text--base"><?php echo e($data->title); ?></h6>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- About -->

    <!-- Profit Calculator -->
    <section class="profit-calculator pt-100 pb-100 bg--shapes overflow-hidden">
        <div class="container position-relative">
            <div class="row align-items-center">
                <div class="col-lg-6">
                    <div class="profit-thumb">
                        <img src="<?php echo e(asset('assets/images/'.$ps->profit_banner)); ?>" alt="profit">
                    </div>
                </div>
                <div class="col-lg-6">
                    <div class="profit-calculator-area">
                        <div class="section-header text-lg-start">
                            <h6 class="section-header__subtitle"><?php echo app('translator')->get('Profit Calculator'); ?></h6>
                            <h2 class="section-header__title"><?php echo e($ps->profit_title); ?></h2>
                            <p>
                               <?php
                                   echo $ps->profit_text;
                               ?>
                            </p>
                        </div>
                        <form id="profitCalculate" class="row gy-4" action="<?php echo e(route('front.profit.calculate')); ?>" method="POST">
                            <?php if ($__env->exists('includes.user.form-both')) echo $__env->make('includes.user.form-both', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                            <?php echo csrf_field(); ?>
                            <div class="col-md-6">
                                <label for="select-plan" class="form-label"><?php echo app('translator')->get('Select Plan'); ?></label>
                                <select name="plan" id="select-plan" class="form-control form--control bg--section">
                                    <?php $__currentLoopData = $plans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($data->id); ?>"><?php echo e($data->title); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                            <div class="col-md-6">
                                <label for="amount" class="form-label"><?php echo app('translator')->get('Enter Amount'); ?></label>
                                <input type="number" name="amount" class="form-control form--control bg--section" placeholder="0.00">
                            </div>
                            <div class="col-md-12">
                                <label for="profit-amount" class="form-label"><?php echo app('translator')->get('Profit Amount'); ?></label>
                                <input type="text" class="form-control form--control bg--section" id="profit-calculate-amount"
                                    value="0.00" readonly>
                            </div>
                            <div class="col-md-12">
                                <button class="cmn--btn" type="submit"><?php echo app('translator')->get('Calculate Now'); ?></button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- Profit Calculator -->

    <!-- Investment Plan -->
    <section class="investment-plan-section overflow-hidden bg--gradient-light pb-50 pt-100 border-top">
        <div class="container">
            <div class="section-header text-center">
                <h6 class="section-header__subtitle"><?php echo app('translator')->get('Pricing Plan'); ?></h6>
                <h2 class="section-header__title"><?php echo e($ps->plan_title); ?></h2>
                <p>
                    <?php
                        echo $ps->plan_subtitle;
                    ?>
                </p>
            </div>
            <div class="pricing--wrapper row g-3 g-md-4 g-lg-3 g-xxl-4 justify-content-center">
                <?php $__currentLoopData = $plans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php
                    $schedule = \App\Models\ManageSchedule::where('time',$data->schedule_hour)->first();
                ?>
                    <div class="col-lg-3 col-sm-6 col-md-6">
                        <div class="plan__item">
                            <div class="plan__item-header">
                                <div class="left">
                                    <h5 class="title"><?php echo e($data->title); ?></h5>
                                    <span><?php echo e($data->subtitle); ?></span>
                                </div>
                                <div class="right">
                                    <h5 class="title"><?php echo e($data->profit_percentage); ?>%</h5>
                                    <span><?php echo app('translator')->get('Return'); ?></span>
                                </div>
                            </div>
                            <div class="plan__item-body">
                                <ul>
                                    <li>
                                        <span class="name"><?php echo app('translator')->get('Profit'); ?></span>
                                        <span class="info">
                                            <?php echo e($data->lifetime_return == 1 ? 'Lifetime' :  'Every '.$schedule->name); ?>

                                        </span>
                                    </li>

                                    <li>
                                        <span class="name me-1"><?php echo app('translator')->get('Capital will back'); ?></span>
                                        <span class="badge align-self-center me-auto bg--<?php echo e($data->captial_return == 1 ? 'primary' : 'danger'); ?>"><?php echo e($data->captial_return == 1 ? 'Yes' : 'No'); ?></span>
                                    </li>

                                    <li>
                                        <span class="name <?php echo e($data->profit_repeat == NULL ?? me-1); ?>"><?php echo app('translator')->get('Repeatable'); ?></span>
                                        <?php if($data->profit_repeat == NULL): ?>  
                                            <span class="badge align-self-center me-auto bg--danger"><?php echo app('translator')->get('NO'); ?></span>
                                        <?php else: ?> 
                                            <span class="info">
                                                <?php echo e($data->profit_repeat.' Times'); ?>

                                            </span>
                                        <?php endif; ?>
                                    </li>
                                </ul>
                                
                                <?php if($data->invest_type == 'range'): ?>
                                    <h6 class="text-center amount-range"><?php echo e(showPrice($data->min_amount)); ?> - <?php echo e(showPrice($data->max_amount)); ?></h6>
                                <?php else: ?> 
                                    <h6 class="text-center amount-range"><?php echo e(showPrice($data->fixed_amount)); ?></h6>
                                <?php endif; ?>
                                <button class="cmn--btn w-100 invest-plan" type="button" data-bs-toggle="modal"
                                    data-bs-target="#invest-modal" data-title="<?php echo e($data->title); ?>" data-id="<?php echo e($data->id); ?>" data-type="<?php echo e($data->invest_type == 'range' ? 0 : 1); ?>" data-fixAmount="<?php echo e(rootPrice($data->fixed_amount)); ?>">
                                    <?php echo app('translator')->get('Invest Now'); ?>
                                </button>
                            </div>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
            <div class="text-center mt-5">
                <a href="<?php echo e(route('front.plans')); ?>" class="cmn--btn btn-outline"><?php echo app('translator')->get('All Packages'); ?></a>
            </div>
        </div>
    </section>
    <!-- Investment Plan -->

    <!-- Partners -->
    <section class="partner-section pt-50 pb-50 overflow-hidden bg--gradient-light">
        <div class="container">
            <div class="partner-slider owl-theme owl-carousel">
                <?php $__currentLoopData = $partners; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?> 
                    <div class="partner-item border">
                        <img src="<?php echo e(asset('assets/images/'.$data->photo)); ?>" alt="brand">
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
    </section>
    <!-- Partners -->

    <!-- Transactions -->
    <section class="transactions-section pt-50 pb-100 bg--gradient-light">
        <div class="container">
            <ul class="nav nav-tabs nav--tabs justify-content-center mb-4">
                <li>
                    <a href="#deposit-log" class="cmn--btn active" data-bs-toggle="tab"><?php echo app('translator')->get('Deposit Log'); ?></a>
                </li>
                <li>
                    <a href="#withdraw-log" class="cmn--btn" data-bs-toggle="tab"><?php echo app('translator')->get('Withdraw Log'); ?></a>
                </li>
            </ul>
            <div class="tab-content">
                <div class="tab-pane fade show active" id="deposit-log">
                    <div class="table-responsive table--mobile-lg">
                        <table class="table table-mobile-lg bg--body">
                            <thead>
                                <tr>
                                    <th><?php echo app('translator')->get('Date'); ?></th>
                                    <th><?php echo app('translator')->get('Transaction Number'); ?></th>
                                    <th><?php echo app('translator')->get('Method'); ?></th>
                                    <th><?php echo app('translator')->get('Account Name'); ?></th>
                                    <th><?php echo app('translator')->get('Amount'); ?></th>
                                    <th><?php echo app('translator')->get('Status'); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = getDeposits(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php
                                        $user = App\Models\User::whereId($data->user_id)->first();
                                    ?>
                                    <tr>
                                        <td data-label="Date"><?php echo e($data->created_at->format('M d, Y')); ?></td>
                                        <td data-label="Transaction Number"><?php echo e(strtoupper($data->deposit_number)); ?></td>
                                        <td data-label="Method"><?php echo e(ucfirst($data->method)); ?></td>
                                        <td data-label="Account Name"><?php echo e($user != NULL ? $user->name : 'Customer Deleted'); ?></td>
                                        <td data-label="Amount"><?php echo e(showPrice($data->amount)); ?></td>
                                        <td data-label="Status">
                                            <?php if($data->status == 'pending'): ?>
                                                <span class="badge badge--warning"><?php echo app('translator')->get('Pending'); ?></span>
                                            <?php else: ?> 
                                                <span class="badge badge--success"><?php echo app('translator')->get('Completed'); ?></span>
                                            <?php endif; ?>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                </div>
                <div class="tab-pane fade" id="withdraw-log">
                    <div class="table-responsive table--mobile-lg">
                        <table class="table table-mobile-lg bg--body">
                            <thead>
                                <tr>
                                    <th><?php echo app('translator')->get('Date'); ?></th>
                                    <th><?php echo app('translator')->get('Transaction no'); ?></th>
                                    <th><?php echo app('translator')->get('Method'); ?></th>
                                    <th><?php echo app('translator')->get('Account Name'); ?></th>
                                    <th><?php echo app('translator')->get('Amount'); ?></th>
                                    <th><?php echo app('translator')->get('Fee'); ?></th>
                                    <th><?php echo app('translator')->get('Status'); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = getWithdraws(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php
                                        $user = App\Models\User::whereId($data->user_id)->first();
                                    ?>
                                    <tr>
                                        <td data-label="Date"><?php echo e($data->created_at->format('M d, Y')); ?></td>
                                        <td data-label="Transaction Number"><?php echo e(strtoupper($data->txnid)); ?></td>
                                        <td data-label="Method"><?php echo e(ucfirst($data->method)); ?></td>
                                        <td data-label="Account Name"><?php echo e($user != NULL ? $user->name : 'Customer Deleted'); ?></td>
                                        <td data-label="Amount"><?php echo e(showPrice($data->amount)); ?></td>
                                        <td data-label="Fee"><?php echo e(showPrice($data->fee)); ?></td>
                                        <td data-label="Status">
                                            <?php if($data->status == 'pending'): ?>
                                                <span class="badge badge--warning"><?php echo app('translator')->get('Pending'); ?></span>
                                            <?php elseif($data->status == 'completed'): ?>
                                                <span class="badge badge--success"><?php echo app('translator')->get('Completed'); ?></span>
                                            <?php else: ?> 
                                                <span class="badge badge--danger"><?php echo app('translator')->get('Rejected'); ?></span>
                                            <?php endif; ?>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- Transactions -->

    <!-- How To Start -->
    <section class="how-to-start-section pt-100 border-top border-bottom overflow-hidden">
        <div class="container">
            <div class="row align-items-center flex-wrap-reverse gy-5">
                <div class="col-lg-6">
                    <div class="pe-xl-4 pe-xxl-5">
                        <div class="section-header text-lg-end">
                            <h6 class="section-header__subtitle"><?php echo app('translator')->get('How To Get Started'); ?></h6>
                            <h2 class="section-header__title"><?php echo e($ps->start_title); ?></h2>
                            <p>
                                <?php
                                    echo $ps->start_text;
                                ?>
                            </p>
                        </div>
                        <div class="how-wrapper">
                            <?php $__currentLoopData = $process; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="how__item">
                                    <div class="how__item-thumb">
                                        <i class="<?php echo e($data->icon); ?>"></i>
                                    </div>
                                    <div class="how__item-content">
                                        <h5 class="how__item-title text--base">
                                            <?php echo e($data->title); ?>

                                        </h5>
                                        <p>
                                           <?php
                                               echo $data->details;
                                           ?>
                                        </p>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>
                </div>
                <div class="col-lg-6">
                    <div class="how-thumb">
                        <img src="<?php echo e(asset('assets/images/'.$ps->start_photo)); ?>" alt="about" />
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- How To Start -->

    <!-- Choose -->
    <?php if ($__env->exists('partials.front.choose')) echo $__env->make('partials.front.choose', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <!-- Choose -->

    <!-- Referral -->
    <section class="referral-section pt-50 pb-100">
        <div class="container">
            <div class="row align-items-center justify-content-between flex-wrap-reverse">
                <div class="col-lg-6 col-xl-5">
                    <div class="referral-thumb">
                        <img src="<?php echo e(asset('assets/images/'.$ps->referral_banner)); ?>" alt="about">
                    </div>
                </div>
                <div class="col-lg-6">
                    <div class="section-header mb-lg-0">
                        <h6 class="section-header__subtitle"><?php echo app('translator')->get('Referral Comission'); ?></h6>
                        <h2 class="section-header__title"><?php echo e($ps->referral_title); ?></h2>
                        <p>
                            <?php
                                echo $ps->referral_text;
                            ?>
                        </p>
                        <div class="comission-area">
                            <?php if($ps->referral_percentage): ?>
                                <?php $__currentLoopData = json_decode($ps->referral_percentage,true); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="comission-item">
                                        <div class="thumb">
                                            <?php echo e($data); ?>%
                                        </div>
                                        <div class="cont">
                                            <div class="name"><?php echo app('translator')->get('Level 0'); ?> <?php echo e($key + 1); ?></div>
                                        </div>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php endif; ?>
                        </div>
                        <a href="#" class="cmn--btn">
                            <?php echo app('translator')->get('Send Referral Link'); ?> <span class="round-effect"><i
                                    class="fas fa-long-arrow-alt-right"></i></span>
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- Referral -->

    <!-- Team Members -->
    <section class="team-section pt-100 bg--section pb-100 border-top">
        <div class="container">
            <div class="section-header text-center">
                <h6 class="section-header__subtitle"><?php echo app('translator')->get('Team'); ?></h6>
                <h2 class="section-header__title"><?php echo e($ps->team_title); ?></h2>
                <p>
                    <?php
                        echo $ps->team_text;
                    ?>
                </p>
            </div>
            <div class="row g-md-3 g-4 g-xl-4 justify-content-center">
                <?php $__currentLoopData = $teams; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="col-lg-3 col-md-4 col-sm-6">
                        <div class="team__card bg--section">
                            <div class="team__card-img">
                                <img src="<?php echo e(asset('assets/images/'.$data->photo)); ?>" alt="team">
                            </div>
                            <div class="team__card-cont">
                                <h6 class="team__card-cont-title"><?php echo e($data->name); ?></h6>
                                <ul class="social-icons py-1 py-md-0 me-md-auto">
                                    <li>
                                        <a href="<?php echo e($data->fb_link); ?>"><i class="fab fa-facebook-f"></i></a>
                                    </li>
                                    <li>
                                        <a href="<?php echo e($data->twitter_link); ?>"><i class="fab fa-twitter"></i></a>
                                    </li>
                                    <li>
                                        <a href="<?php echo e($data->instra_link); ?>"><i class="fab fa-instagram"></i></a>
                                    </li>
                                    <li>
                                        <a href="<?php echo e($data->linkedin_link); ?>"><i class="fab fa-linkedin-in"></i></a>
                                    </li>
                                    <li>
                                        <a href="<?php echo e($data->youtube_link); ?>"><i class="fab fa-youtube"></i></a>
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
    </section>
    <!-- Team Members -->

    <!-- Testimonials -->
    <section class="testimonial-section pt-100 pb-50 border-top">
        <div class="container">
            <div class="client__slider owl-theme owl-carousel">
                <?php $__currentLoopData = $testimonials; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="client__item">
                        <div class="client__item-img">
                            <img src="<?php echo e(asset('assets/images/'.$data->photo)); ?>" alt="clients">
                        </div>
                        <div class="client__item-cont bg--section">
                            <div class="section-header">
                                <h6 class="section-header__subtitle"><?php echo e($data->title); ?></h6>
                                <h3 class="section-header__title"><?php echo e($data->subtitle); ?></h3>
                            </div>
                            <blockquote class="quote">
                                <?php
                                    echo $data->details;
                                ?>
                            </blockquote>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
    </section>
    <!-- Testimonials -->

    <!-- CTAs -->
    <section class="ctas-section bg--gradient position-relative overflow-hidden" style="background: <?php echo e($ps->call_bg); ?>">
        <div class="particle"></div>
        <div class="particle2"></div>
        <div class="particle3"></div>
        <div class="particle4"></div>
        <div class="container">
            <div class="section-header text-center text-white mb-0">
                <h6 class="section-header__subtitle"><?php echo e($ps->call_title); ?>?</h6>
                <h2 class="section-header__title"><?php echo e($ps->call_subtitle); ?></h2>
                <a href="<?php echo e($ps->call_link); ?>" class="cmn--btn">
                    <?php echo app('translator')->get('Get Started'); ?>
                    <span class="round-effect"><i class="fas fa-long-arrow-alt-right"></i></span>
                </a>
            </div>
        </div>
    </section>
    <!-- CTAs -->

    <!-- Blogs -->
    <section class="blog-section pt-100 pb-50 border-top">
        <div class="container">
            <div class="section-header">
                <h6 class="section-header__subtitle"><?php echo app('translator')->get('Blog Posts'); ?></h6>
                <h2 class="section-header__title"><?php echo e($ps->blog_title); ?></h2>
                <p>
                    <?php
                        echo $ps->blog_text;
                    ?>
                </p>
            </div>
            <div class="row g-4 g-lg-3 g-xl-4 justify-content-center">
                <?php $__currentLoopData = $blogs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="col-lg-4 col-md-6 col-sm-10">
                        <div class="blog__item">
                            <a href="<?php echo e(route('blog.details',$data->slug)); ?>" class="blog-link">&nbsp;</a>
                            <div class="blog__item-img">
                                <img src="<?php echo e(asset('assets/images/'.$data->photo)); ?>" alt="blog">
                                <span class="date">
                                    <span><?php echo e($data->created_at->format('M')); ?></span>
                                    <span><?php echo e($data->created_at->format('d')); ?></span>
                                </span>
                            </div>
                            <div class="blog__item-cont">
                                <h5 class="blog__item-cont-title line--2">
                                    <?php echo e(Str::limit($data->title,30)); ?>

                                </h5>
                                <p class="line--3">
                                    <?php echo e(Str::limit($data->details,90)); ?>


                                </p>

                                <div class="blog__author">
                                    <div class="author">
                                        <img src="<?php echo e(asset('assets/images/'.getAdmin()->photo)); ?>" alt="blog">
                                        <h6><?php echo app('translator')->get('Admin'); ?></h6>
                                    </div>
                                    <span class="read--more"><?php echo app('translator')->get('Read More'); ?></span>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
    </section>
    <!-- Blogs -->

    <!-- Payment Gateways -->
    <?php if ($__env->exists('partials.front.payment')) echo $__env->make('partials.front.payment', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <!-- Payment Gateways -->

<?php $__env->stopSection(); ?>

<?php $__env->startPush('js'); ?>
    
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.front', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\mamp\htdocs\geniushyip\project\resources\views/frontend/index.blade.php ENDPATH**/ ?>